"use strict";
var KTDatatablesAdvancedRowGrouping = function() {

	var init = function() {
		var table = $('#kt_datatable');

		// begin first table
		table.DataTable({
			responsive: true,
			pageLength: 25,
			order: [[2, 'DESC']],
			drawCallback: function(settings) {
				var api = this.api();
				var rows = api.rows({page: 'current'}).nodes();
				var last = null;

				api.column(2, {page: 'current'}).data().each(function(group, i) {
					if (last !== group) {
						$(rows).eq(i).before(
							'<tr class="group"><td colspan="10">' + group + '</td></tr>',
						);
						last = group;
					}
				});
			},
			columnDefs: [
				{
					// hide columns by index number
					targets: [0, 2],
					visible: false,
				},
				{
				
				},
				{
					targets: 9,
					render: function(data, type, full, meta) {
						var status = {
						    0: {'title': 'انتظار تکمیل', 'class': ' label-light-danger'},
						    1: {'title': 'تایید شده', 'class': ' label-light-success'},
							5: {'title': 'رد شده', 'class': 'label-light-primary'},
							
							/*4: {'title': 'لغو شده', 'class': ' label-light-primary'},
							5: {'title': 'اطلاعات', 'class': ' label-light-info'},
							6: {'title': 'خطار', 'class': ' label-light-danger'},
							7: {'title': 'هشدار', 'class': ' label-light-warning'},*/
						};
						if (typeof status[data] === 'undefined') {
							return data;
						}
						return '<span class="label label-lg font-weight-bold' + status[data].class + ' label-inline">' + status[data].title + '</span>';
					},
				},
				{
					targets: 8,
					render: function(data, type, full, meta) {
						var status = {
							0: {'title': 'درانتظار تایید', 'state': 'danger'},
							5: {'title': 'بلاک شده', 'state': 'primary'},
							1: {'title': 'تایید شده', 'state': 'success'},
						};
						if (typeof status[data] === 'undefined') {
							return data;
						}
						return '<span class="label label-' + status[data].state + ' label-dot mr-2"></span>' +
							'<span class="font-weight-bold text-' + status[data].state + '">' + status[data].title + '</span>';
					},
				},
			],
		});
	};

	return {

		//main function to initiate the module
		init: function() {
			init();
		},

	};

}();

jQuery(document).ready(function() {
	KTDatatablesAdvancedRowGrouping.init();
});
