"use strict";
var KTDatatablesAdvancedRowGrouping = function() {

	var init = function() {
		var table = $('#kt_datatableorder');

		// begin first table
		table.DataTable({
			responsive: true,
			pageLength: 25,
			order: [[0, 'DESC']],
			drawCallback: function(settings) {
				var api = this.api();
				var rows = api.rows({page: 'current'}).nodes();
				var last = null;
                    
				api.column(2, {page: 'current'}).data().each(function(group, i) {
					if (last !== group) {
						$(rows).eq(i).before(
							'<tr class="group"><td colspan="10">' + group + '</td></tr>',
						);
						last = group;
					}
				});
			},
			columnDefs: [
				{
					// hide columns by index number
					targets: [0, 2],
					visible: false,
				},
				{
				
				},
				{
					targets: 3,
					render: function(data, type, full, meta) {
						var status = {
						    
						    'SDlivery': {'apndstyle':'background-color: #d2f9ff;color: #17a2b8', 'title': 'برداشت فیزیکی', 'class': ' btn-light-teal'},
						    'Shopping': {'title': 'فروشگاه', 'class': ' btn-light-info'},
						    'Invate_Gift': {'title': 'هدیه دعوت', 'class': ' btn-light-dark'},
						    'BuyGold': {'title': 'خرید', 'class': ' btn-success'},
						    'StickBack': {'apndstyle':'background-color: #dcf0d5;color: #4aa728','title': 'بازگشت باکس', 'class': ' btn-light-warning'},
						    'DepositProfit_Stack': {'title': 'سود استیک', 'class': ' btn-light-primary'},
						    'SellGold': {'title': 'فروش', 'class': ' btn-danger'},
						    'BuyGold-Bazzar': {'title': 'خرید طلا بازار', 'class': ' btn-light-success'},
						    
						    'SellGold-Bazzar': {'title': 'فروش طلا بازار', 'class': ' btn-light-danger'},
						    'BuyGold-wt': {'title': 'درخواست خرید', 'class': ' btn-dark'},
						    'SellGold-wt': {'title': 'درخواست فروش', 'class': ' btn-dark'},
						    'WalletCharge': {'title': 'شارژ کیف پول', 'class': ' btn-warning'},
						    
						    'LoanBack': {'title': 'بازپرداخت قسط وام', 'class': ' btn-light-primary'},
						    'loan': {'title': 'ارائه وام', 'class': ' btn-warning'},
						    'CashWithd': {'title': 'درخواست تسویه', 'class': ' btn-light-warning'},
						    'InvateGift1': {'title': 'هدیه دعوت', 'class': ' btn-light-dark'},
						    
						    'Damage': {'title': 'جریمه سیستمی', 'class': ' btn-danger'},
						    
						};
						if (typeof status[data] === 'undefined') {
							return data;
						}
						return '<btn class="btn btn-block font-weight-bold' + status[data].class + ' btn-inline" style="' + status[data].apndstyle + '">' + status[data].title + '</span>';
					},
				},
				{},
				{}, 
			],
		});
	};

	return {

		//main function to initiate the module
		init: function() {
			init();
		},

	};

}();

jQuery(document).ready(function() {
	KTDatatablesAdvancedRowGrouping.init();
});
