"use strict";
var KTDatatablesAdvancedRowGrouping = function() {

	var init = function() {
		var table = $('#kt_datatableorder');

		// begin first table
		table.DataTable({
			responsive: true,
			pageLength: 25,
			order: [[0, 'DESC']],
			drawCallback: function(settings) {
				var api = this.api();
				var rows = api.rows({page: 'current'}).nodes();
				var last = null;
                    
				api.column(2, {page: 'current'}).data().each(function(group, i) {
					if (last !== group) {
						$(rows).eq(i).before(
							'<tr class="group"><td colspan="9">' + group + '</td></tr>',
						);
						last = group;
					}
				});
			},
			columnDefs: [
				{
					// hide columns by index number
					targets: [0, 2],
					visible: false,
				},
				{
				
				},
				{
					targets: 3,
					render: function(data, type, full, meta) {
						var status = {};
						if (typeof status[data] === 'undefined') {
							return data;
						}
						return '<btn class="btn btn-block font-weight-bold' + status[data].class + ' btn-inline" style="' + status[data].apndstyle + '">' + status[data].title + '</span>';
					},
				},
				{},
				{}, 
			],
		});
	};

	return {

		//main function to initiate the module
		init: function() {
			init();
		},

	};

}();

jQuery(document).ready(function() {
	KTDatatablesAdvancedRowGrouping.init();
});
