"use strict";
var KTDatatablesAdvancedRowGrouping = function() {

	var init = function() {
		var table = $('#kt_datatableorder');

		// begin first table
		table.DataTable({
			responsive: true,
			pageLength: 25,
			order: [[0, 'DESC']],
			drawCallback: function(settings) {
				var api = this.api();
				var rows = api.rows({page: 'current'}).nodes();
				var last = null;
                    
				api.column(2, {page: 'current'}).data().each(function(group, i) {
					if (last !== group) {
						$(rows).eq(i).before(
							'<tr class="group"><td colspan="10">' + group + '</td></tr>',
						);
						last = group;
					}
				});
			},
			columnDefs: [
				{
					// hide columns by index number
					targets: [0, 2],
					visible: false,
				},
				{
				
				},
				{
					targets: 3,
					render: function(data, type, full, meta) {
						var status = {
						    
						    'Forwarded-to-Reception': {'title': 'پـرداخت کاربر به پذیرنده', 'class': ' btn-light-warning'},
						    'Chasbac-From-Reception': {'title': 'واریز کش بک به حساب کاربر', 'class': ' btn-success'},
						    'received-From-Customer': {'title': 'دریافتی پذیرنده از حساب کاربر', 'class': ' btn-light-primary'},
						    'Chasbac-From-Customer': {'title': 'برداشت کش بک از پذیرنده', 'class': ' btn-danger'},
						    'ChargeWallet': {'title': ' شارژ کیف پول ', 'class': ' btn-warning'},
						    
						    'ForwardedTransfer': {'title': 'انتقال داخلی > ارسال', 'class': ' btn-Color3'},
						    'IncomingTransfer': {'title': 'انتقال داخلی > دریافت', 'class': ' btn-Color4'},
						    
						    'CashWithd': {'title': 'برداشت کاربر', 'class': ' btn-Color1'},
						    'Sysyemfee': {'title': 'کارمزد برداشت کاربر', 'class': ' btn-Color2'},
						    
						    'ReqAganeCart': {'title': 'درخواست صدور مجدد کارت', 'class': ' btn-Color11'},
    
                            'received-From-Customer-Comiss': {'title': 'دریافت کارمزد از پذیرنده', 'class': ' btn-Color12'},

						    'BuyCard': {'title': 'خـریـد کارت', 'class': ' btn-light-success'},
						    'UpgradCard': {'title': 'ارتـقا کارت', 'class': ' btn-success'},
						    
						    'Plus_InvertWlPlus': {'title': 'شارژ حساب کیف پول', 'class': ' btn-light-info'},
						    'Invate_Gift': {'title': 'دعـوت دوست', 'class': ' btn-info'},
						    
						    'SendSMS': {'title': 'ارسال پیامک پذیرنده', 'class': ' btn-Color13'},
						    'ConvertPoints': {'title': 'تبدیل امتیاز به پول', 'class': ' btn-Color14'},
						    
						    
						};
						if (typeof status[data] === 'undefined') {
							return data;
						}
						return '<btn class="btn btn-block font-weight-bold' + status[data].class + ' btn-inline" style="' + status[data].apndstyle + '">' + status[data].title + '</span>';
					},
				},
				{},
				{}, 
			],
		});
	};

	return {

		//main function to initiate the module
		init: function() {
			init();
		},

	};

}();

jQuery(document).ready(function() {
	KTDatatablesAdvancedRowGrouping.init();
});
